//=============================================================================
// villaA_JunkieFilter.js
// Copyright (c) 2024- 村人Ａ
//=============================================================================
/*:
 * @target MZ
 * @plugindesc マップ画面にトリップしたような（酔ったような）フィルター効果を付加します。
 * @author 村人Ａ
 *
 * @command switchFilter
 * @text フィルターのON
 * @desc トリップフィルターを適用開始します。マップ表示が酩酊・幻覚的な雰囲気になります。
 *
 * @command offFilter
 * @text フィルターを終わる
 * @desc 現在適用中のトリップフィルターを解除します。
 *
 * @help
 * ============================================================================
 * 概要
 * ============================================================================
 * このプラグインは、マップ画面にトリップしたような不思議なフィルター効果を
 * 与えます。  
 * フィルターをONにすると、画面がゆがんだり色ズレやぼかしが発生し、  
 * 酔ったような、または幻覚を見ているような雰囲気を出せます。
 * これにより、プレイヤーが特殊な状態に陥ったシーンや、現実離れした
 * イベント演出などを行うことができます。
 *
 * ### フィルターのON (switchFilter)
 * トリップフィルターを有効化します。
 * 実行後、マップ上の表示が不安定・幻覚的なエフェクトを伴うようになります。
 *
 * ### フィルターを終わる (offFilter)
 * 適用中のトリップフィルターを解除します。
 * フィルターが外れ、画面は元通りの安定した表示に戻ります。
 *
 * ============================================================================
 * 使い方
 * ============================================================================
 * 1. **プラグイン導入**  
 *    プラグインマネージャーで「villaA_JunkieFilter.js」を有効にしてください。
 *
 * 2. **フィルター適用**  
 *    イベントコマンド「プラグインコマンド」で`switchFilter`を実行すると、
 *    マップにトリップフィルターがかかります。
 *
 * 3. **フィルター解除**  
 *    イベントコマンド「プラグインコマンド」で`offFilter`を実行すれば、
 *    トリップフィルターが外れ、正常な表示に戻ります。
 *
 * 例：
 * ```
 * ◆プラグインコマンド：villaA_JunkieFilter, フィルターのON
 * （マップ上が酔ったような表示に）
 *
 * --- イベント進行後 ---
 *
 * ◆プラグインコマンド：villaA_JunkieFilter, フィルターを終わる
 * （フィルター解除、元の表示へ）
 * ```
 *
 * ============================================================================
 * 注意事項
 * ============================================================================
 * - フィルター適用中は描画負荷が増す可能性があります。
 * - 他のフィルタープラグインとの競合を避けるため、テストプレイを推奨します。
 *
 * ============================================================================
 * 不具合報告
 * ============================================================================
 * 不具合はXまたはメールで報告してください。
 * Xアカウント：＠rpgmaker_villaA
 * メール：villaa.contact＠gmail.com
 *
 */
 
function _0x3bbd(){const _0x2e553d=['playerPos','initialize','update','width','switchFilter','filters','8SVpZxx','switchJunkieFilter','38872780EHiNoy','9aUkqzc','apply','(((.+)+)+)+$','uniforms','reset','removeJunkieFilter','offFilter','487210QOEfCY','Filter','toString','_spriteset','_scene','height','prototype','villaA_JunkieFilter','486062rXGwBL','4095469cjmrYI','junkieFilter','createSpriteset','isFadeout','registerCommand','screenY','call','11DhzAsA','_fragmentSrc','create','353746LoDvzS','15rqsmus','2620008AgweJn','11528072hIoJSq','search','setJunkieFilterToSpriteset','updateTime','amp','remove'];_0x3bbd=function(){return _0x2e553d;};return _0x3bbd();}const _0x755520=_0x5957;function _0x5957(_0x1cf0e0,_0x5405f6){const _0x140e37=_0x3bbd();return _0x5957=function(_0x47ff15,_0x57a648){_0x47ff15=_0x47ff15-0x128;let _0x3bbd64=_0x140e37[_0x47ff15];return _0x3bbd64;},_0x5957(_0x1cf0e0,_0x5405f6);}(function(_0x100c06,_0x32f954){const _0x333168=_0x5957,_0x2c44cf=_0x100c06();while(!![]){try{const _0x1a4cfa=-parseInt(_0x333168(0x138))/0x1+-parseInt(_0x333168(0x12d))/0x2*(parseInt(_0x333168(0x139))/0x3)+-parseInt(_0x333168(0x147))/0x4*(parseInt(_0x333168(0x151))/0x5)+-parseInt(_0x333168(0x13a))/0x6+parseInt(_0x333168(0x12e))/0x7+parseInt(_0x333168(0x13b))/0x8*(-parseInt(_0x333168(0x14a))/0x9)+-parseInt(_0x333168(0x149))/0xa*(-parseInt(_0x333168(0x135))/0xb);if(_0x1a4cfa===_0x32f954)break;else _0x2c44cf['push'](_0x2c44cf['shift']());}catch(_0x2a03c6){_0x2c44cf['push'](_0x2c44cf['shift']());}}}(_0x3bbd,0xcada3));const _0x57a648=(function(){let _0x2c0c78=!![];return function(_0x1aaef1,_0x2ea19b){const _0x2514be=_0x2c0c78?function(){const _0x2defdb=_0x5957;if(_0x2ea19b){const _0x1284f0=_0x2ea19b[_0x2defdb(0x14b)](_0x1aaef1,arguments);return _0x2ea19b=null,_0x1284f0;}}:function(){};return _0x2c0c78=![],_0x2514be;};}()),_0x47ff15=_0x57a648(this,function(){const _0x105e25=_0x5957;return _0x47ff15['toString']()[_0x105e25(0x13c)](_0x105e25(0x14c))[_0x105e25(0x153)]()['constructor'](_0x47ff15)[_0x105e25(0x13c)]('(((.+)+)+)+$');});_0x47ff15();{'use\x20strict';const pluginName=_0x755520(0x12c);function JunkieFilter(){const _0x55c794=_0x755520;this[_0x55c794(0x142)](...arguments);}JunkieFilter[_0x755520(0x12b)]=Object[_0x755520(0x137)](PIXI[_0x755520(0x152)]['prototype']),JunkieFilter[_0x755520(0x12b)]['constructor']=JunkieFilter,JunkieFilter[_0x755520(0x12b)][_0x755520(0x142)]=function(){const _0x20088c=_0x755520;PIXI[_0x20088c(0x152)][_0x20088c(0x134)](this,null,this[_0x20088c(0x136)]()),this[_0x20088c(0x131)]=![],this[_0x20088c(0x14e)]();},JunkieFilter['prototype'][_0x755520(0x14e)]=function(){const _0x197e3d=_0x755520;this[_0x197e3d(0x14d)][_0x197e3d(0x13f)]=0x0,this[_0x197e3d(0x14d)][_0x197e3d(0x141)]=[$gamePlayer['screenX']()/Graphics[_0x197e3d(0x144)],($gamePlayer[_0x197e3d(0x133)]()-0x18)/Graphics[_0x197e3d(0x12a)]];},JunkieFilter['prototype'][_0x755520(0x140)]=function(){const _0x1c028e=_0x755520;$gameSystem[_0x1c028e(0x148)]=![],SceneManager['_scene']&&SceneManager[_0x1c028e(0x129)][_0x1c028e(0x14f)]&&SceneManager[_0x1c028e(0x129)][_0x1c028e(0x14f)]();},JunkieFilter[_0x755520(0x12b)][_0x755520(0x13e)]=function(){const _0x190ee8=_0x755520;this['uniforms'][_0x190ee8(0x141)]=[$gamePlayer['screenX']()/Graphics[_0x190ee8(0x144)],($gamePlayer[_0x190ee8(0x133)]()-0x18)/Graphics[_0x190ee8(0x12a)]];},JunkieFilter['prototype'][_0x755520(0x136)]=function(){return'\x0a\x09\x09\x09varying\x20vec2\x20vTextureCoord;\x0a\x09\x09\x09uniform\x20vec2\x20playerPos;\x0a\x09\x09\x09uniform\x20sampler2D\x20uSampler;\x0a\x09\x09\x09void\x20main()\x20{\x0a\x09\x09\x09\x09vec2\x20uv\x20=\x20vTextureCoord.xy;\x0a\x09\x09\x09\x09vec2\x20direction\x20=\x20uv\x20-\x20playerPos;\x0a\x09\x09\x09\x09float\x20distance\x20=\x20length(direction);\x0a\x09\x09\x09\x09float\x20chromaStrength\x20=\x200.2;\x0a\x09\x09\x09\x09vec2\x20offsetR\x20=\x20uv\x20+\x20chromaStrength\x20*\x20direction\x20*\x20distance;\x0a\x09\x09\x09\x09vec2\x20offsetG\x20=\x20uv;\x0a\x09\x09\x09\x09vec2\x20offsetB\x20=\x20uv\x20-\x20chromaStrength\x20*\x20direction\x20*\x20distance;\x0a\x09\x09\x09\x09float\x20r\x20=\x20texture2D(uSampler,\x20offsetR).r;\x0a\x09\x09\x09\x09float\x20g\x20=\x20texture2D(uSampler,\x20offsetG).g;\x0a\x09\x09\x09\x09float\x20b\x20=\x20texture2D(uSampler,\x20offsetB).b;\x0a\x09\x09\x09\x09vec4\x20chromaColor\x20=\x20vec4(r,\x20g,\x20b,\x201.0);\x0a\x09\x09\x09\x09float\x20blurStrength\x20=\x20smoothstep(0.0,\x201.0,\x20distance)\x20*\x200.03;\x0a\x09\x09\x09\x09vec4\x20blurredColor\x20=\x20vec4(0.0);\x0a\x09\x09\x09\x09blurredColor\x20+=\x20texture2D(uSampler,\x20uv\x20+\x20blurStrength\x20*\x20vec2(-1.0,\x20-1.0));\x0a\x09\x09\x09\x09blurredColor\x20+=\x20texture2D(uSampler,\x20uv\x20+\x20blurStrength\x20*\x20vec2(\x200.0,\x20-1.0));\x0a\x09\x09\x09\x09blurredColor\x20+=\x20texture2D(uSampler,\x20uv\x20+\x20blurStrength\x20*\x20vec2(\x201.0,\x20-1.0));\x0a\x09\x09\x09\x09blurredColor\x20+=\x20texture2D(uSampler,\x20uv\x20+\x20blurStrength\x20*\x20vec2(-1.0,\x20\x200.0));\x0a\x09\x09\x09\x09blurredColor\x20+=\x20texture2D(uSampler,\x20uv\x20+\x20blurStrength\x20*\x20vec2(\x200.0,\x20\x200.0));\x0a\x09\x09\x09\x09blurredColor\x20+=\x20texture2D(uSampler,\x20uv\x20+\x20blurStrength\x20*\x20vec2(\x201.0,\x20\x200.0));\x0a\x09\x09\x09\x09blurredColor\x20+=\x20texture2D(uSampler,\x20uv\x20+\x20blurStrength\x20*\x20vec2(-1.0,\x20\x201.0));\x0a\x09\x09\x09\x09blurredColor\x20+=\x20texture2D(uSampler,\x20uv\x20+\x20blurStrength\x20*\x20vec2(\x200.0,\x20\x201.0));\x0a\x09\x09\x09\x09blurredColor\x20+=\x20texture2D(uSampler,\x20uv\x20+\x20blurStrength\x20*\x20vec2(\x201.0,\x20\x201.0));\x0a\x09\x09\x09\x09blurredColor\x20/=\x209.0;\x0a\x09\x09\x09\x09gl_FragColor\x20=\x20mix(chromaColor,\x20blurredColor,\x200.5);\x0a\x09\x09\x09}\x0a\x20\x20\x20\x20\x20\x20\x20\x20';},PluginManager['registerCommand'](pluginName,_0x755520(0x145),_0x3e28af=>{const _0x332b79=_0x755520;$gameSystem[_0x332b79(0x148)]=!![],SceneManager[_0x332b79(0x129)][_0x332b79(0x13d)]();}),PluginManager[_0x755520(0x132)](pluginName,_0x755520(0x150),_0x59c199=>{const _0x20d972=_0x755520;if(!SceneManager[_0x20d972(0x129)][_0x20d972(0x12f)])return;SceneManager[_0x20d972(0x129)][_0x20d972(0x12f)][_0x20d972(0x140)]();});const _alias_Game_System_initialize=Game_System[_0x755520(0x12b)][_0x755520(0x142)];Game_System['prototype'][_0x755520(0x142)]=function(){const _0x35af93=_0x755520;_alias_Game_System_initialize[_0x35af93(0x134)](this),this[_0x35af93(0x148)]=![];};const _alias_Scene_Map_createSpriteset=Scene_Map[_0x755520(0x12b)][_0x755520(0x130)];Scene_Map['prototype'][_0x755520(0x130)]=function(){const _0xe65a43=_0x755520;_alias_Scene_Map_createSpriteset[_0xe65a43(0x134)](this),!this[_0xe65a43(0x128)]['filters']&&(this[_0xe65a43(0x128)][_0xe65a43(0x146)]=[]),$gameSystem[_0xe65a43(0x148)]&&this[_0xe65a43(0x13d)]();},Scene_Map[_0x755520(0x12b)][_0x755520(0x13d)]=function(){const _0x355eba=_0x755520;this[_0x355eba(0x12f)]?this['junkieFilter'][_0x355eba(0x14e)]():(this[_0x355eba(0x12f)]=new JunkieFilter(),this[_0x355eba(0x128)][_0x355eba(0x146)]['push'](this[_0x355eba(0x12f)]));},Scene_Map['prototype'][_0x755520(0x14f)]=function(){const _0x19d57d=_0x755520;this['junkieFilter']&&(this['_spriteset'][_0x19d57d(0x146)]=this['_spriteset']['filters']['filter'](_0x4e7452=>_0x4e7452!==this['junkieFilter']),this['junkieFilter']=null);;};const _alias_Scene_Map_update=Scene_Map[_0x755520(0x12b)][_0x755520(0x143)];Scene_Map[_0x755520(0x12b)][_0x755520(0x143)]=function(){const _0x329fd9=_0x755520;_alias_Scene_Map_update['call'](this),this['junkieFilter']&&this[_0x329fd9(0x12f)][_0x329fd9(0x13e)]();};};
































